
id=dat$obs
dat=dat[-c(ncol(dat))]



# NOTE: based on the data, run the corresponding code #

########## table 6 (2): lagged US wheat production*lagged 1-year food aid probability (instrument) ##########
########## table 6 (3): lagged US wheat production*lagged 2-year average food aid probability (instrument) ##########
########## table 6 (4): lagged US wheat production*lagged 4-year average food aid probability (instrument) ##########
########## table 6 (5): normalizing US wheat aid by population ##########
########## table 6 (6): taking natural logs of US wheat aid and production ##########
########## table 6 (7): dropping former Soviet Union countries ##########
########## table 6 (8): dropping years 1971-1973 ##########

tsls.2=ivreg(intra_state~.-instrument|.-wheat_aid+instrument,data=dat)
cluster.robust.se(tsls.2,id)

y=dat$intra_state
x=dat$wheat_aid
y.sd=sd(y)
x.sd=sd(x)
coef=coef(tsls.2)[2]
coef*(x.sd/y.sd)

dat=dat[-c(1)]
dat$clusterid=id
fs=lm(wheat_aid~.-clusterid,data=dat)
fn=lm(wheat_aid~.-instrument-clusterid,data=dat)
waldtest(fs,fn,vcov=clusterVCV(dat,fs,cluster1="clusterid"))$F[2]

########## table 6 (9): including a lagged US wheat aid ##########

tsls.2=ivreg(intra_state~.-instrument-l_instrument|.-wheat_aid-l_wheat_aid+instrument+l_instrument,data=dat)
cluster.robust.se(tsls.2,id)

y=dat$intra_state
x=dat$wheat_aid
y.sd=sd(y)
x.sd=sd(x)
coef=coef(tsls.2)[2]
coef*(x.sd/y.sd)

##### KP test #####

dat1=dat[-c(1,4)]
dat2=dat[-c(1,2)]

dat1$clusterid=id
fs <- lm(wheat_aid~.-clusterid,data=dat1)
fn <- lm(wheat_aid~.-instrument-l_instrument-clusterid,data=dat1)
waldtest(fs,fn,vcov=clusterVCV(dat1,fs,cluster1="clusterid"))$F[2]

dat2$clusterid=id
fs <- lm(l_wheat_aid~.-clusterid,data=dat2)
fn <- lm(l_wheat_aid~.-instrument-l_instrument-clusterid,data=dat2)
waldtest(fs,fn,vcov=clusterVCV(dat2,fs,cluster1="clusterid"))$F[2]

########## table 6 (10): including a lead of US wheat aid ##########

tsls.2=ivreg(intra_state~.-instrument-f_instrument|.-wheat_aid-f_wheat_aid+instrument+f_instrument,data=dat)
cluster.robust.se(tsls.2,id)

y=dat$intra_state
x=dat$wheat_aid
y.sd=sd(y)
x.sd=sd(x)
coef=coef(tsls.2)[2]
coef*(x.sd/y.sd)

##### KP test #####

dat1=dat[-c(1,4)]
dat2=dat[-c(1,2)]

dat1$clusterid=id
fs <- lm(wheat_aid~.-clusterid,data=dat1)
fn <- lm(wheat_aid~.-instrument-f_instrument-clusterid,data=dat1)
waldtest(fs,fn,vcov=clusterVCV(dat1,fs,cluster1="clusterid"))$F[2]

dat2$clusterid=id
fs <- lm(f_wheat_aid~.-clusterid,data=dat2)
fn <- lm(f_wheat_aid~.-instrument-f_instrument-clusterid,data=dat2)
waldtest(fs,fn,vcov=clusterVCV(dat2,fs,cluster1="clusterid"))$F[2]
